/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_TileEntity_CircuitAssemblyLine
extends GT_MetaTileEntity_MultiBlockBase {
    private NBTTagCompound type = new NBTTagCompound();
    private GT_Recipe bufferedRecipe;
    private final Collection<GT_Recipe> GT_RECIPE_COLLECTION = new HashSet<GT_Recipe>();

    public String getTypeForDisplay() {
        if (this.type.equals((Object)new NBTTagCompound())) {
            return "";
        }
        return GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)CircuitImprintLoader.getStackFromTag(this.type)));
    }

    public GT_TileEntity_CircuitAssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_CircuitAssemblyLine(String aName) {
        super(aName);
    }

    private boolean imprintMachine(ItemStack itemStack) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            return true;
        }
        if (!GT_Utility.isStackValid((Object)itemStack)) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof BW_Meta_Items.BW_GT_MetaGenCircuits && itemStack.func_77960_j() == 0 && itemStack.func_77978_p() != null && this.type.equals((Object)new NBTTagCompound())) {
            this.type = itemStack.func_77978_p();
            this.mInventory[1] = null;
            this.getBaseMetaTileEntity().issueBlockUpdate();
            return true;
        }
        return false;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(212)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.type = aNBT.func_74775_l("Type");
        super.loadNBTData(aNBT);
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            aNBT.func_74782_a("Type", (NBTBase)this.type);
        }
        super.saveNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            aNBT.func_74782_a("Type", (NBTBase)this.type);
        }
        super.saveNBTData(aNBT);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        if (this.type.equals((Object)new NBTTagCompound()) && !this.imprintMachine(itemStack)) {
            return false;
        }
        if (this.bufferedRecipe != null && this.bufferedRecipe.isRecipeInputEqual(true, false, BW_Util.getFluidsFromInputHatches(this), BW_Util.getItemsFromInputBusses(this))) {
            BW_Util.calculateOverclockedNessMultiPefectOC(this.bufferedRecipe.mEUt, this.bufferedRecipe.mDuration, 1, this.getMaxInputVoltage(), this);
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = this.bufferedRecipe.mOutputs;
            this.mOutputFluids = this.bufferedRecipe.mFluidOutputs;
            this.updateSlots();
            return true;
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)this.type);
        if (stack == null) {
            return false;
        }
        if (this.GT_RECIPE_COLLECTION.isEmpty()) {
            for (GT_Recipe recipe : BWRecipes.instance.getMappingsFor((byte)3).mRecipeList) {
                if (!GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[0], (ItemStack)stack, (boolean)true)) continue;
                this.GT_RECIPE_COLLECTION.add(recipe);
            }
        }
        for (GT_Recipe recipe : this.GT_RECIPE_COLLECTION) {
            if (!recipe.isRecipeInputEqual(true, false, BW_Util.getFluidsFromInputHatches(this), BW_Util.getItemsFromInputBusses(this))) continue;
            this.bufferedRecipe = recipe;
            BW_Util.calculateOverclockedNessMulti(this.bufferedRecipe.mEUt, this.bufferedRecipe.mDuration, 1, this.getMaxInputVoltage(), this);
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = this.bufferedRecipe.mOutputs;
            this.mOutputFluids = this.bufferedRecipe.mFluidOutputs;
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int x;
        boolean backwards;
        int length;
        boolean sided;
        int zBase;
        short yBase;
        int xBase;
        block27: {
            IGregTechTileEntity igtte;
            block26: {
                int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
                int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
                xBase = aBaseMetaTileEntity.getXCoord() + xDir;
                yBase = aBaseMetaTileEntity.getYCoord();
                zBase = aBaseMetaTileEntity.getZCoord() + zDir;
                boolean bl = sided = xDir == 0;
                if (sided) {
                    ++zBase;
                } else {
                    ++xBase;
                }
                length = 0;
                backwards = false;
                do {
                    if ((igtte = aBaseMetaTileEntity.getIGregTechTileEntity(sided ? xBase + length : xBase - 1, yBase - 2, sided ? zBase - 1 : zBase + length)) == null) {
                        backwards = true;
                        length = 0;
                        break block26;
                    }
                    if (igtte.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OutputBus) break block26;
                } while (++length <= 7);
                backwards = true;
                length = 0;
            }
            if (backwards) {
                do {
                    if ((igtte = aBaseMetaTileEntity.getIGregTechTileEntity(sided ? xBase + length : xBase - 1, yBase - 2, sided ? zBase - 1 : zBase + length)) == null) {
                        return false;
                    }
                    if (igtte.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OutputBus) break block27;
                } while (--length >= -7);
                return false;
            }
        }
        if (sided) {
            zBase -= 2;
        } else {
            xBase -= 2;
        }
        int n = x = backwards && sided ? length : 0;
        while (x <= (backwards && sided ? 0 : (sided ? length : 2))) {
            for (int y = -2; y <= 0; ++y) {
                int z;
                int n2 = z = backwards && !sided ? length : 0;
                while (z <= (backwards && !sided ? 0 : (sided ? 2 : length))) {
                    if (xBase + x != this.getBaseMetaTileEntity().getXCoord() || yBase + y != this.getBaseMetaTileEntity().getYCoord() || zBase + z != this.getBaseMetaTileEntity().getZCoord()) {
                        IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntity(xBase + x, yBase + y, zBase + z);
                        Block block = aBaseMetaTileEntity.getBlock(xBase + x, yBase + y, zBase + z);
                        byte meta = aBaseMetaTileEntity.getMetaID(xBase + x, yBase + y, zBase + z);
                        block0 : switch (y) {
                            case -2: {
                                switch (sided ? z : x) {
                                    case 0: 
                                    case 2: {
                                        if (this.addMaintenanceToMachineList(tTileEntity, 16) || this.addInputToMachineList(tTileEntity, 16) || block == GregTech_API.sBlockCasings2 && meta == 0) break block0;
                                        return false;
                                    }
                                    case 1: {
                                        if (this.addInputToMachineList(tTileEntity, 16) || (sided ? x : z) == length && this.addOutputToMachineList(tTileEntity, 16)) break block0;
                                        return false;
                                    }
                                }
                                break;
                            }
                            case -1: {
                                switch (sided ? z : x) {
                                    case 0: 
                                    case 2: {
                                        if (BW_Util.calculateGlassTier(block, meta) >= 4) break block0;
                                        return false;
                                    }
                                    case 1: {
                                        if (block == GregTech_API.sBlockCasings2 && meta == 5) break block0;
                                        return false;
                                    }
                                }
                                break;
                            }
                            case 0: {
                                if (this.addEnergyInputToMachineList(tTileEntity, 16) || block == GregTech_API.sBlockCasings3 && meta == 10) break;
                                return false;
                            }
                        }
                    }
                    ++z;
                }
            }
            ++x;
        }
        return this.mEnergyHatches.size() == 1 && this.mMaintenanceHatches.size() == 1;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus && ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mTier == 0) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        return false;
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus && ((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity).mTier == 0) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_CircuitAssemblyLine(this.mName);
    }

    public String[] getDescription() {
        return new String[]{"Circuit Assembly Line", "Size(WxHxD): (2-7)x3x3, variable length", "Bottom: Steel Machine Casing(or 1x Maintenance or Input Hatch),", "ULV Input Bus (Last ULV Output Bus), Steel Machine Casing", "Middle: EV+ Tier Glass, Assembling Line Casing, EV+ Tier Glass", "Top: Grate Machine Casing (or Controller or 1x Energy Hatch)", "Up to 7 repeating slices, last is Output Bus", "Imprint this machine with a Circuit Imprint,", "by putting the imprint in the controller.", "Every Circuit Assembly Line can only be imprinted ONCE.", StatCollector.func_74838_a((String)"tooltip.bw.1.name") + "\u00a72" + " BartWorks"};
    }

    public String[] getInfoData() {
        String[] ret = new String[super.getInfoData().length + 1];
        System.arraycopy(super.getInfoData(), 0, ret, 0, super.getInfoData().length);
        ret[super.getInfoData().length] = "Imprinted with: " + GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)CircuitImprintLoader.getStackFromTag(this.type)));
        return ret;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.CASING_BLOCKS[16];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE));
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.CASING_BLOCKS[16];
        }
        return iTextureArray;
    }
}

